// Version : Scilab 5.2.2
// Operating Syatem : Ubuntu 16.04 LTS
//Assume fp=1000 hz and fs=5000 hz
//Use the formula to convert the pass band ripple and To convert stop band attenuation in dB(A in dB)=-20*log10(Ap or As)
// assume kp=1.93 dB and ks=13.97 dB 


clc;
clear;
xdel(winsid());
fp= input( " Enter the pass band edge (Hz) = ");
fs= input( "Enter the stop band edge (Hz) = ");
kp= 1.93             //assume the pass band ripple(dB)
ks= 13.97            //assume the stop band attenuation(dB) 
Fsf=44000;         //sampling frequency
//Converting to digital frequency
Fp1=2*3.14*fp/Fsf;
Fs1=2*3.14*fs/Fsf;

// Digital filter specifications ( rad/samples ) 
N = log10(sqrt((10^(0.1*ks)-1)/(10^(0.1*kp)-1)))/log10(Fs1/Fp1);  //Order of the filter
N = ceil(N);          //rounded to nearest integer
disp(N," IIR Filter order N =");

oc = 0.5*((Fp1*Fsf)/((10^(0.1*kp)-1)^(1/(2*N))) + (Fs1*Fsf)/((10^(0.1*ks)-1)^(1/(2*N))) );  //Cut off Frequency
disp(oc, "Cutoff Frequency in rad/ seconds OC =")
[Hz]=iir(N,'bp','ellip',[Fp1/2,Fs1/2],[0.2,0.200])   //the sum of last matrix [0.2,0.200] must be less than 1  
[p,z,g]=iir(N,'bp','ellip',[Fp1/2,Fs1/2],[0.2,0.200])
[Hw,w]=frmag(Hz,256);
figure(1)
plot(2*w,abs(Hw));
xlabel('Normalized Digital frequency w->')
ylabel('magnitude');
title('Magnitude response of IIR filter')
xgrid(1)
[y,Fs]=wavread("H:\DSP SCILAB\Final\meow.wav")   //Reading input .wav signal file path of the .wav file must be changed
figure(2)
subplot(2,1,1)
plot(y)
title('Input signal waveform');
xlabel('Frequency-->');
ylabel('Magnitude-->');
playsnd(y)
outlo=filter(abs(z),abs(p),y);     //Passing accquired signal through desired filter
subplot(2,1,2)
plot(outlo)
title('Output signal waveform after filtering')
xlabel('Frequency-->');
ylabel('Magnitude-->');

N =length(y);                                    //Power spectral density of the Input signal
Y = fft(y,-1); 
Pxx = (1/N)*(abs(Y).^2); //Peridogram Estimate 
figure(3)
plot2d3('gnn',[1:N],Pxx)
title('Input signal power spectral density')
xlabel('Analog Frequency in Hz f --->')
ylabel('Magnitude |H(w)|=')
xgrid(1)
playsnd(outlo)

N=length(outlo)                                 ////Power spectral density of the Ouput signal
OL = fft(outlo,-1); 
Fxx = (1/N)*(abs(OL).^2); //Peridogram Estimate 
figure(4)
plot2d3('gnn',Fxx)
title('Output signal power spectral density')
xlabel('Analog Frequency in Hz f --->')
ylabel('Magnitude |H(w)|=')
xgrid(1)





